/*
 * Decompiled with CFR 0.152.
 */
package com.fastasyncworldedit.core.extension.factory.parser.transform;

import com.fastasyncworldedit.core.command.SuggestInputParseException;
import com.fastasyncworldedit.core.configuration.Caption;
import com.fastasyncworldedit.core.extension.factory.parser.FaweParser;
import com.fastasyncworldedit.core.extent.ResettableExtent;
import com.fastasyncworldedit.core.extent.transform.MultiTransform;
import com.fastasyncworldedit.core.extent.transform.RandomTransform;
import com.fastasyncworldedit.core.math.random.TrueRandom;
import com.fastasyncworldedit.core.util.StringMan;
import com.sk89q.minecraft.util.commands.CommandLocals;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.NoMatchException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.internal.expression.Expression;
import com.sk89q.worldedit.util.formatting.text.TextComponent;
import com.sk89q.worldedit.util.formatting.text.event.ClickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RichTransformParser
extends FaweParser<ResettableExtent> {
    public RichTransformParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ResettableExtent parseFromInput(String input, ParserContext context) throws InputParseException {
        Actor actor;
        if (input.isEmpty()) {
            return null;
        }
        ArrayList<Double> unionChances = new ArrayList<Double>();
        ArrayList<Double> intersectionChances = new ArrayList<Double>();
        ArrayList<ResettableExtent> intersection = new ArrayList<ResettableExtent>();
        ArrayList<ResettableExtent> union = new ArrayList<ResettableExtent>();
        CommandLocals locals = new CommandLocals();
        Actor actor2 = actor = context != null ? context.getActor() : null;
        if (actor != null) {
            locals.put(Actor.class, actor);
        }
        try {
            List<Map.Entry<FaweParser.ParseEntry, List<String>>> parsed = RichTransformParser.parse(input);
            for (Map.Entry<FaweParser.ParseEntry, List<String>> entry : parsed) {
                ResettableExtent transform;
                FaweParser.ParseEntry pe = entry.getKey();
                Object command = pe.getInput();
                double chance = 1.0;
                if (((String)command).isEmpty()) {
                    transform = this.parseFromInput(StringMan.join((Collection)entry.getValue(), ','), context);
                } else if (!this.worldEdit.getTransformFactory().containsAlias((String)command)) {
                    int percentIndex = ((String)command).indexOf(37);
                    if (percentIndex == -1) throw new NoMatchException(Caption.of("fawe.error.parse.unknown-transform", pe.getFull(), TextComponent.of("https://intellectualsites.github.io/fastasyncworldedit-documentation/transforms/transforms").clickEvent(ClickEvent.openUrl("https://intellectualsites.github.io/fastasyncworldedit-documentation/transforms/transforms"))));
                    chance = Expression.compile(((String)command).substring(0, percentIndex), new String[0]).evaluate(new double[0]);
                    command = ((String)command).substring(percentIndex + 1);
                    if (!entry.getValue().isEmpty()) {
                        if (!((String)command).isEmpty()) {
                            command = (String)command + " ";
                        }
                        command = (String)command + StringMan.join((Collection)entry.getValue(), " ");
                    }
                    transform = this.parseFromInput((String)command, context);
                } else {
                    try {
                        transform = (ResettableExtent)this.worldEdit.getTransformFactory().parseWithoutRich(pe.getFull(), context);
                    }
                    catch (SuggestInputParseException rethrow) {
                        throw rethrow;
                    }
                    catch (Throwable e) {
                        throw new NoMatchException(Caption.of("fawe.error.parse.unknown-transform", pe.getFull(), TextComponent.of("https://intellectualsites.github.io/fastasyncworldedit-documentation/transforms/transforms").clickEvent(ClickEvent.openUrl("https://intellectualsites.github.io/fastasyncworldedit-documentation/transforms/transforms"))));
                    }
                }
                if (pe.isAnd()) {
                    intersectionChances.add(chance);
                    intersection.add(transform);
                    continue;
                }
                if (!intersection.isEmpty()) {
                    if (intersection.size() == 1) {
                        throw new InputParseException(Caption.of("fawe.error.parse.invalid-dangling-character", "&"));
                    }
                    MultiTransform multi = new MultiTransform();
                    double total = 0.0;
                    for (int i = 0; i < intersection.size(); ++i) {
                        Double value = (Double)intersectionChances.get(i);
                        total += value.doubleValue();
                        multi.add((ResettableExtent)intersection.get(i), value);
                    }
                    union.add(multi);
                    unionChances.add(total);
                    intersection.clear();
                    intersectionChances.clear();
                }
                unionChances.add(chance);
                union.add(transform);
            }
        }
        catch (Throwable e) {
            throw new InputParseException(TextComponent.of(e.getMessage()), e);
        }
        if (!intersection.isEmpty()) {
            if (intersection.size() == 1) {
                throw new InputParseException(Caption.of("fawe.error.parse.invalid-dangling-character", "&"));
            }
            MultiTransform multi = new MultiTransform();
            double total = 0.0;
            for (int i = 0; i < intersection.size(); ++i) {
                Double value = (Double)intersectionChances.get(i);
                total += value.doubleValue();
                multi.add((ResettableExtent)intersection.get(i), value);
            }
            union.add(multi);
            unionChances.add(total);
            intersection.clear();
            intersectionChances.clear();
        }
        if (union.isEmpty()) {
            throw new NoMatchException(Caption.of("fawe.error.parse.unknown-transform", input, TextComponent.of("https://intellectualsites.github.io/fastasyncworldedit-documentation/transforms/transforms").clickEvent(ClickEvent.openUrl("https://intellectualsites.github.io/fastasyncworldedit-documentation/transforms/transforms"))));
        }
        if (union.size() == 1) {
            return (ResettableExtent)union.get(0);
        }
        RandomTransform random = new RandomTransform(new TrueRandom());
        for (int i = 0; i < union.size(); ++i) {
            random.add((ResettableExtent)union.get(i), (Double)unionChances.get(i));
        }
        return random;
    }

    @Override
    public List<String> getMatchedAliases() {
        return Collections.emptyList();
    }
}

